<x-kasir.contents>
    <x-slot:title>{{ $data['title'] }}</x-slot:title>
    <x-slot:menuActive>{{ $data['menuActive'] }} </x-slot:menuActive>
    <x-slot:head>
        <link rel="stylesheet" href="{{ asset('') }}assets/admin/plugins/icheck-bootstrap/icheck-bootstrap.min.css">
        <link rel="stylesheet" href="{{ asset('assets/admin/') }}/plugins/ekko-lightbox/ekko-lightbox.css">
        <link rel="stylesheet" href="{{ asset('') }}assets/admin/plugins/sweetalert2/sweetalert2.min.css">
        <link rel="stylesheet" href="{{ asset('') }}assets/admin/plugins/toastr/toastr.min.css">
        <style>
            /* width */
            ::-webkit-scrollbar {
                width: 5px;
            }

            /* Track */
            ::-webkit-scrollbar-track {
                box-shadow: inset 0 0 5px white;
                border-radius: 10px;
            }

            /* Handle */
            ::-webkit-scrollbar-thumb {
                background: rgb(247, 2, 2);
                border-radius: 10px;
            }

            .member {
                border: 1px solid rgb(207, 206, 206);
                border-radius: 5px;
                width: 97%;
                height: 250px;
                position: absolute;
                overflow: auto;
                margin-top: 3px;
                background-color: white;
                z-index: 1;
            }

            a.list-group-item {
                padding: 7px;
                padding-left: 10px;
                color: black;
                border: 0px;
            }

            a.list-group-item:hover {
                background-color: red !important;
                color: white;
                font-weight: bold;
            }
        </style>
    </x-slot:head>


    <div class="content-wrapper">
        <!-- Content Header (Page header) -->
        <div class="content-header">
            <div class="container-fluid">

            </div><!-- /.container-fluid -->
        </div>

        <div class="content">
            <div class="container-fluid">
                <div class="row">
                    <div class="col-lg-8">
                        <div class="card card-danger card-outline">
                            <div class="overlay bg-white " style="opacity: 0.5">
                                <i class="fas fa-3x fa-spinner fa-pulse"></i>
                            </div>
                            <div class="card-header">
                                <form class="form-inline float-right">
                                    <input class="form-control mr-sm-2" type="search" placeholder="Search"
                                        style="width: 460px;" aria-label="Search" name="cari">
                                    <button class="btn btn-primary " type="submit"> <i class="fa fa-search mr-2"></i>
                                        Cari!</button>
                                </form>
                                <h3 class="card-title"><i class="fa fa-server text-danger"></i> {{ $data['page'] }}</h3>
                            </div>

                            <div class="card-body">

                                <div class="row">
                                    @forelse ($hadiah as $h)
                                        <div class="col-sm-2 mb-3">
                                            <div class="icheck-blue d-inline "
                                                style="position: absolute; left: 15px; background-color: white; padding: 6px;  padding-right: 0px;">
                                                <input type="radio" name="item" id="hadiah{{ $h->id }}"
                                                    value="{{ $h->id }}" class=" pilih_hadiah">
                                                <label for="hadiah{{ $h->id }}">
                                                </label>
                                            </div>
                                            <a href="#" class="pilih" data-id="{{ $h->id }}">
                                                <img src="{{ asset('/storage/produk/' . $h->gambar) }}"
                                                    class="img-fluid " alt="{{ $h->nm_hadiah }}" />
                                            </a>
                                            <div class="bg-danger text-center">{{ $h->poin }} Poin</div>
                                        </div>
                                    @empty
                                    @endforelse
                                </div>

                                {{ $hadiah->links('components.admin.pagination') }}

                            </div>
                        </div><!-- /.card -->
                    </div>
                    <!-- /.col-md-6 -->
                    <div class="col-lg-4">
                        <div class="card card-danger card-outline">
                            <div class="card-header">

                            </div>
                            <div class="card-body">
                                <label for="">Nama Item</label>
                                <input type="text" name="" id="nama" class="form-control" readonly>
                                <div class="row">
                                    <div class="col-md-6">
                                        <label for="">Stok </label>
                                        <input type="text" name="" id="stok" class="form-control"
                                            readonly>
                                    </div>
                                    <div class="col-md-6">
                                        <label for="">Poin Penukaran </label>
                                        <input type="text" name="" id="poin" class="form-control"
                                            readonly>
                                    </div>
                                </div>
                                <hr>
                                <label for="">Kode / Nama Member</label>
                                <input type="text" name="" id="member" class="form-control"
                                    placeholder="Search....">
                                <div class="show_member">
                                </div>
                                <hr>
                                <div class="row mb-2">
                                    <div class="col-md-6">
                                        <label for=""> Kode Member</label>
                                        <input type="text" name="" id="kode_member" class="form-control"
                                            readonly>
                                    </div>
                                    <div class="col-md-6">
                                        <label for="">Jumlah Poin </label>
                                        <input type="text" name="" id="poin_member" class="form-control"
                                            readonly>
                                    </div>
                                </div>
                                <label for="">Alamat Member</label>
                                <textarea name="" id="alamat" class="form-control" readonly></textarea>
                                <hr>
                                <button class="btn btn-lg btn-block btn-danger simpan" style="height: 80px;"><i
                                        class="fa fa-save"></i>
                                    Simpan
                                    Penukaran</button>
                            </div>
                        </div><!-- /.card -->
                    </div>


                    <div class="col-lg-12">
                        <div class="card card-danger card-outline">
                            <div class="card-header">
                                <form class="form-inline float-right">
                                    <input class="form-control mr-sm-2" type="search" placeholder="Search"
                                        aria-label="Search" name="search">
                                    <button class="btn btn-primary " type="submit"> <i
                                            class="fa fa-search mr-2"></i>
                                        Cari!</button>
                                </form>
                                <h3 class="card-title"><i class="fa fa-server text-danger"></i> Data Penukaran
                                </h3>
                            </div>
                            <div class="card-body">
                                <table class="table table-bordered table-hover myTable tab ">
                                    <thead>
                                        <tr>
                                            <th width="3%">No</th>
                                            <th>Gambar</th>
                                            <th>Nama Item</th>
                                            <th>Poin Tukar</th>
                                            <th>Member</th>
                                            <th>Tgl. Tukar</th>
                                            <th>Opsi</th>
                                        </tr>
                                    </thead>
                                    <tbody id="view">
                                        @forelse ($poin as $p)
                                            <tr>
                                                <td class="text-center">{{ $no++ }}</td>
                                                <td class="text-center">
                                                    <img alt="Avatar" class="table-avatar"
                                                        src="{{ asset('/storage/produk/' . hadiah($p->kodetran)->gambar) }}"
                                                        width="40px">
                                                </td>
                                                <td>{{ hadiah($p->kodetran)->nm_hadiah }}</td>
                                                <td class="text-center">{{ hadiah($p->kodetran)->poin }} Poin</td>
                                                <td>{{ $p->member->nm_member }}</td>
                                                <td>{{ tgl_time($p->created_at) }}</td>
                                                <td class="text-center">
                                                    <button class="btn btn-sm btn-dark cetak"
                                                        data-id="{{ $p->id }}"><i class="fa fa-print"></i>
                                                        Print</button>
                                                </td>
                                            </tr>
                                        @empty
                                            <tr>
                                                <td colspan="20" class="text-center">Data masih kosong</td>
                                            </tr>
                                        @endforelse
                                    </tbody>
                                </table>
                                {{ $poin->links('components.admin.pagination') }}
                            </div>
                        </div>
                    </div>
                    <!-- /.col-md-6 -->

                    <div id="hidedata">
                        <div id="print">
                            <div class="tampil_data"></div>
                        </div>
                    </div>


                </div>
                <!-- /.row -->
            </div><!-- /.container-fluid -->
        </div>
    </div>
    <!-- /.content -->
    <input type="hidden" name="" id="kode" value="0">
    <input type="hidden" name="" id="id_member" value="0">

    <input type="hidden" name="" id="ckprint" value="{{ modull('PRINT')->status }}">
    <x-slot:foot>
        <script src="{{ asset('assets/admin/') }}/plugins/ekko-lightbox/ekko-lightbox.min.js"></script>
        <script src="{{ asset('') }}assets/admin/plugins/sweetalert2/sweetalert2.all.min.js"></script>
        <script src="{{ asset('') }}assets/admin/plugins/toastr/toastr.min.js"></script>
        <script src="{{ asset('assets/admin/') }}/tukar.js"></script>
    </x-slot:foot>
</x-kasir.contents>
